function s = similar(X, Y)
%SIM Evaluates the similarity of two vectors
%   This is the function presented in [2] to check watermarks
%   in a picture. Typically, X and Y are drawn from a random
%   process N(0,1).
%   sim(X, Y) = X.Y / |X|
%
%   See: COXWMK, COXDETECT, COXTEST, COXEXTRACT

%   Fabien A.P. Petitcolas 27-11-97
%   Copyright (c) 1997 by the University of Cambridge
%   $Revision: 0.1$

%   References:
%        1) Ross J. Anderson, editor. Information hiding: first
%           international workshop, volume 1174 of Lecture notes
%           in computer science. University of Cambridge, Isaac
%           Newton Institute, Springer Verlag, Berlin, Germany,
%           May 1996.
%        2) Ingemar J. Cox, Joe Kilian, Tom Leighton, and Talal
%           Shamoon. A secure, robust watermark for multimedia.
%           In Anderson [1], pages 183-206


% Simply take the inverse DCT of the modified matrix
[r,c] = size(X);
if (c ~= 1 & r ~= 1)
   error('X should be a vector.')
end
if (c>1)&(r==1)
   X = X(:);
end
[r,c] = size(Y);
if (c ~= 1 & r ~= 1)
   error('Y should be a vector.')
end
if (c>1)&(r==1)
   Y = Y(:);
end

s = X' * Y / sqrt(Y' * Y);