function [J, W] = CoxWmkColor(I, alpha, N, W)
%COXWMKCOLOR Insert a random watermark.
%   [J, W] = COXWMKCOLOR(I) watermarks the 24 bit color picture I using
%   Cox's scheme [2] with default parameters. J is the watermarked
%   picture and W is the watermark.
%   The watermark W is drawn from a Normal random process N(0,1)
%   if it is not given by the user as last parameter.
% 
%   [J, W] = COXWMKCOLOR(I, Alpha, N) watermarks the color picture I
%   using modifying the Nth largest DCT coefficients v_i in the
%   following way: v_i := v_i * (1 + Alpha * w_i) where w_i
%   are the components of the watermak.
%
%   Use IMSHOW(MAT2GRAY(J)) to display the output.
%
%   See: COXDETECT

%   Fabien A.P. Petitcolas 26-11-1997
%   Copyright (c) 1997 by the University of Cambridge
%   $Revision: 0.6$

%   References:
%        1) Ross J. Anderson, editor. Information hiding: first
%           international workshop, volume 1174 of Lecture notes
%           in computer science. University of Cambridge, Isaac
%           Newton Institute, Springer Verlag, Berlin, Germany,
%           May 1996.
%        2) Ingemar J. Cox, Joe Kilian, Tom Leighton, and Talal
%           Shamoon. A secure, robust watermark for multimedia.
%           In Anderson [1], pages 183-206

if (nargin == 1)
   N = 1000;
   alpha = 0.1;
   W = randn(1,N);
end
if (nargin == 2)
   N = 1000;
   W = randn(1,N);
end
if (nargin == 3)
   W = randn(1,N);
end

if (~isrgb(I))
   error('This is not a color picture.');
end

J = zeros(size(I));
[r c d] = size(I);

% Watermark each color separatly
for l = 1:3
   Jl = CoxWmk(I(:,:,l), alpha, N, W);
   J(:,:,l) = Jl;
end
