function response = CoxTest(M, N)
%COXTEST Test the "similarity" function of NEC's marking technique
%   response = COXTEST(M, N) generates a response plot using the
%   similarity function sim(X, Y). M and N are optional parameters
%   M determines the number of tests and N the length of the random
%   vectors used in the test. An intial random vector W is computed
%   then the similarity of this vector with M other random vectors X
%   is computed. In the middle of the computation X is set to W.
%
%   See: COXWMK, COXDETECT, COXEXTRACT, SIM

%   Fabien A.P. Petitcolas 26-11-97
%   Copyright (c) 1997 by the University of Cambridge
%   $Revision: 0.5$

%   References:
%        1) Ross J. Anderson, editor. Information hiding: first
%           international workshop, volume 1174 of Lecture notes
%           in computer science. University of Cambridge, Isaac
%           Newton Institute, Springer Verlag, Berlin, Germany,
%           May 1996.
%        2) Ingemar J. Cox, Joe Kilian, Tom Leighton, and Talal
%           Shamoon. A secure, robust watermark for multimedia.
%           In Anderson [1], pages 183-206

if (nargin == 0)
   M = 500;
   N = 1000;
end
if (nargin == 1)
   N = 1000;
end

W = randn(1,N);

for i = 1:M
   if (i == floor(M / 2))
      X = W;
   else
      X = randn(1,N);
   end
   response(i) = similar(W, X);
end
