function sim = CoxDetect(I, J, W, alpha, N)
%COXDETECT Detect wheter a watermark is present in J.
%   sim = COXDETECT(I, J, W, alpha, N) simply extracts the
%   watermark from J and check whether it is similar to the
%   original one (W). I is the original image.
%   alpha and N are optional parameters used during the
%   embedding of the watermark (see COXWMK)
%
%   See: COXWMK, COXTEST, COXEXTRACT, SIM

%   Fabien A.P. Petitcolas 26-11-1997
%   Copyright (c) 1997 - University of Cambridge
%   $Revision: 0.7$

%   References:
%        1) Ross J. Anderson, editor. Information hiding: first
%           international workshop, volume 1174 of Lecture notes
%           in computer science. University of Cambridge, Isaac
%           Newton Institute, Springer Verlag, Berlin, Germany,
%           May 1996.
%        2) Ingemar J. Cox, Joe Kilian, Tom Leighton, and Talal
%           Shamoon. A secure, robust watermark for multimedia.
%           In Anderson [1], pages 183-206

if (nargin == 3)
   N = 1000;
   alpha = 0.1;
end
if (nargin == 4)
   N = 1000;
end

if (~isrgb(I))
   % First extract the watermark from suspect image
	X = CoxExtract(I, J, alpha, N);
   
   % Compare with original watermark
   sim = Similar(W, X);
else
      % Simple implementation: apply the same algorithm
   % to each color
   for l = 1:3
      % First extract the watermark from suspect image
      X = CoxExtract(I(:, :, l), J(:, :, l), alpha, N);
      % Compare with original watermark
	   sim(l) = similar(W, X);
   end
end
